//=============================================================================

/*:
 * @plugindesc メインメニューを開く時の効果音を変更します。
 * 
 * @author LefTonbo
 *
 * @param Main Menu SE Name
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc メインメニューを開くときの効果音
 * @default Decision1
 *
 * @param Main Menu SE Volume
 * @type number
 * @desc メインメニューを開くときの効果音の音量
 * @default 90
 *
 * @param Main Menu SE Pitch
 * @type number
 * @desc メインメニューを開くときの効果音のピッチ
 * @default 100
 *
 * @param Main Menu No Wait
 * @type boolean
 * @desc メインメニューを開くときのウェイト
 * @default true
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_MainMenuSound = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_MainMenuSound');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.MainMenuSEName = String(LeftPlugin.Parameters['Main Menu SE Name']);
LeftPlugin.Param.MainMenuSEVolume = Number(LeftPlugin.Parameters['Main Menu SE Volume']);
LeftPlugin.Param.MainMenuSEPitch = Number(LeftPlugin.Parameters['Main Menu SE Pitch']);
LeftPlugin.Param.MainMenuNoWait = Boolean(LeftPlugin.Parameters['Main Menu No Wait']);

//=============================================================================

(function() {

//=============================================================================
// Scene_Map
//=============================================================================

// 再定義
Scene_Map.prototype.callMenu = function() {
  AudioManager.playStaticSe(
    { "name": LeftPlugin.Param.MainMenuSEName,
      "pan": 0,
      "pitch": LeftPlugin.Param.MainMenuSEPitch,
      "volume": LeftPlugin.Param.MainMenuSEVolume
    }
  );
  SceneManager.push(Scene_Menu);
  Window_MenuCommand.initCommandPosition();
  $gameTemp.clearDestination();
  this._mapNameWindow.hide();
  if (LeftPlugin.Param.MainMenuNoWait) this._waitCount = 2;
};

//=============================================================================

})();

// EOF